 aR  w / m^9      h	 oP    nSystem-wide
    NAME CpWinProcs

; This is WinProcs.Asm.

CGROUP GROUP CODE


EXTRN  CpScreenInfoNear: NEAR
EXTRN  CpAllocate: NEAR, CpFree: NEAR

PUBLIC CpWinAllocWinMemory


CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP

;  CpWinAllocWinMemory
;
;  This routine allocates memory for an alternate window
;  for the size and format specified by the user
;

eOK          EQU 0
screenFormat EQU 0
gridFormat   EQU 1

ScreenInfoType STRUC
  scrPixelsX    DW ?
  scrPixelsY    DW ?
  scrScreenAddr DD ?
  scrBitsPerPel DB ?
  scrAspectY    DW ?
ScreenInfoType ENDS

WindowRgnType  STRUC
  wrgnFormat       DB ?
  wrgnWidth        DW ?
  wrgnHeight       DW ?
  wrgnBufLength    DW ?
  wrgnBufOff       DW ?
  wrgnBufSeg       DW ?
  wrgnBitsPerPixel DB ?
  wrgnBytesPerLine DW ?
WindowRgnType  ENDS

theWidth     EQU  WORD PTR [BP+20]
theHeight    EQU  WORD PTR [BP+18]
theFormat    EQU  BYTE PTR [BP+16]
pError       EQU DWORD PTR [BP+12]
pWindowPtr   EQU DWORD PTR [BP+08]

dummy        EQU  WORD PTR [BP-02]

CpWinAllocWinMemory PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	PUSH	CX	; 1 local variable

	MOV	AX, SIZE WindowRgnType
	PUSH	AX
	LES	BX, pError
	PUSH	ES
	PUSH	BX
	CALL	CpAllocate
	PUSH	ES
	POP	DS	; Use DS to point to window region area

	LES	BX, pError
	CMP	WORD PTR ES:[BX], eOK
	JE	CpWinAllocCont

	JMP	CpWinAllocError1

CpWinAllocCont:
	MOV	AL, 1	; Assume bitsPerPixel to be 1 (gridFormat)
	CMP	theFormat, screenFormat	; If format is not screenFormat
	JNE	UseGRiDFormat	; then use default bitsPerPixel

UseScreenFormat:
	XOR	AX, AX
	PUSH	DS
	PUSH	AX	; Use window region area for screen info

	MOV	AX, OFFSET CpScreenInfoReturn
	PUSH	CS
	PUSH	AX
	JMP	CpScreenInfoNear	; This is to avoid a FIXUP

CpScreenInfoReturn:
	MOV	AL, DS:scrBitsPerPel

UseGRiDFormat:
	MOV	DL, theFormat
	MOV	DS:wrgnFormat, DL	; windowRegion.format = format

	MOV	DS:wrgnBitsPerPixel, AL	; windowRegion.bitsPerPixel = bitsPerPixel

	MOV	BX, theWidth
	MOV	DS:wrgnWidth, BX	; windowRegion.width = width

	MOV	AH, 0
	MUL	BX	; bit width = width * bitsPerPixel

	MOV  BX, AX
	AND  BX, 0FH	; test to see if (bit width MOD 16) = 0
	PUSHF	; save results for later
	MOV  CL, 3 
	SHR  AX, CL	; determine byte width
	POPF		; if (bit width MOD 16) = 0
	JZ	IsMultipleOf16	; then byte width is large enough

	SHR	AX, 1
	INC	AX	; else round up to next 16
	SHL	AX, 1	; byte size, in terms of bytes

IsMultipleOf16:
	MOV	DS:wrgnBytesPerLine, AX	; save windowRegion.bytesPerLine

	MOV	BX, theHeight
	MOV	DS:wrgnHeight, BX	; windowRegion.height = height

	MUL	BX
	MOV	DS:wrgnBufLength, AX	; windowRegion.height = bytesPerLine * height

	PUSH	AX
	LES	BX, pError
	PUSH	ES
	PUSH BX
	CALL	CpAllocate
	MOV	DS:wrgnBufOff, BX
	MOV	DS:wrgnBufSeg, ES	; windowRegion.pBuf = CpAllocate (bufLength)

	LES	BX, pError
	CMP	WORD PTR ES:[BX], eOK
	JNE	CpWinAllocError2

	LES	DI, DWORD PTR DS:wrgnBufOff
	MOV	CX, DS:wrgnBufLength
	SHR	CX, 1
	XOR	AX, AX
	CLD
	REP	STOSW

	MOV	DX, DS
	JMP	SHORT CpWinAllocExit

CpWinAllocError2:
	PUSH	DS
	XOR	AX, AX
	PUSH	AX
	LEA	AX, dummy
	PUSH	SS
	PUSH	AX
	CALL	CpFree

CpWinAllocError1:
	MOV	AX, 0FH
	MOV	DX, 0FFFFH

CpWinAllocExit:
	LES	BX, pWindowPtr
	MOV	ES:[BX+0], AX
	MOV	ES:[BX+2], DX

	MOV	SP, BP
	POP	BP
	POP	DS
	RET	14
CpWinAllocWinMemory ENDP


CODE ENDS

    END
